#include <allegro.h>
#ifndef NO_GL
#include <alleggl.h>
#endif
#include <time.h>
#include <stdlib.h>
#include "main.h"
#include "game.h"
#include "menu.h"
#include "midi.h"
#include "sfx.h"

int frames;
int fps;
BITMAP *page;

int sound_on = 0;

static int in_game;

static volatile int ticks = 0;
static void ticker(void)
{
	ticks++;
}
END_OF_FUNCTION(ticker);

static void run_init()
{
	in_game = 0;
	menu_init();
}

static void run_end()
{
	exit(0);
}

static void run_frame()
{
	while (keypressed()) {
		int k = readkey();

		k >>= 8;
		if (k == KEY_ESC) {
			if (in_game == 0) {
				if (introtime) introtime = 0;
				else run_end();
			}
			if (in_game == 1) {
				in_game = 0;
				menu_init();
			}
		}
		if (k == KEY_ENTER) {
			if (introtime) {
				introtime = 0;
			} else if (in_game == 0) {
				in_game = 1;
				game_init();
				return;
			}
		}
		if (k == KEY_M) {
			static int flipflop = 0;
			flipflop ^= 1;
			if (flipflop) midi_pause(); else midi_resume();
		}
	}

	if (in_game)
		game_input();
	else
		menu_input();

}

static void run_render()
{
	if (in_game)
		game_render();
	else
		menu_render();

	/*text_mode(-1);
	textprintf_right(page, font, SCREEN_W, 0,
						  makecol(100, 100, 100), "%d fps", fps);
	*/
}

int main(int anr, char *arg[])
{
	int gframes;
	int framecounttime, framecounter;

	srand(time(NULL));
	allegro_init();
	
	LOCK_FUNCTION(ticker);
	LOCK_VARIABLE(ticks);

#ifndef NO_GL
	set_color_depth(16);
	install_allegro_gl();
	
	allegro_gl_set (AGL_COLOR_DEPTH, 16);
	allegro_gl_set (AGL_DOUBLEBUFFER, 1);
	allegro_gl_set (AGL_RENDERMETHOD, 1);
	
	allegro_gl_set (AGL_REQUIRE,
		AGL_COLOR_DEPTH |
		AGL_DOUBLEBUFFER |
		AGL_RENDERMETHOD   
	);

	if (set_gfx_mode(GFX_OPENGL_FULLSCREEN, 640, 480, 0, 0) < 0) {
		allegro_message("Cannot set graphics mode.\n");
		exit(-1);
	}
#else
	if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) < 0) {
		allegro_message("Cannot set graphics mode.\n");
		exit(-1);
	}
	{
		PALETTE pal;
		int r, g, b, i = 0;

		for (r = 0; r < 8; r++)
			for (g = 0; g < 8; g++)
				for (b = 0; b < 4; b++) {
					pal[i].r = r * 63 / 7;
					pal[i].g = g * 63 / 7;
					pal[i].b = b * 63 / 3;
					i++;
				}

		set_palette(pal);
	}
#endif

	install_keyboard();
	install_mouse();

	install_timer();

	install_int_ex(ticker, BPS_TO_TIMER(FPS));

#ifndef NO_GL
	page = screen;
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glDisable(GL_DEPTH_TEST);
	glMatrixMode(GL_PROJECTION);									
	glLoadIdentity();	
	glOrtho(0, 640, 480, 0, -1, 1);						
					
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_POINT_SMOOTH);
	
	glDrawBuffer(GL_BACK);
	
	
	
	
#else
	page = create_bitmap(SCREEN_W, SCREEN_H);
#endif

	run_init();
	
	sfx_create();
	sound_on = 1;
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	if (sound_on) play_midi(&astro_midi, 1);

	framecounter = 0;
	framecounttime = ticks;
	gframes = ticks;
	frames = ticks;
	while (1) {

		while (frames <= ticks) {
			run_frame();
			frames++;
		}
		if (gframes < frames) {
			run_render();
#ifndef NO_GL
			glFlush();
			allegro_gl_flip();
#else
			blit(page, screen, 0, 0, 0, 0, page->w, page->h);
#endif

			gframes = frames;
			framecounter++;

			if (ticks - framecounttime >= FPS) {
				fps = framecounter;
				framecounter = 0;
				framecounttime = ticks;
			}

		}

	}
	run_end();
	return -1;
}

END_OF_MAIN();
